(*************************************************************************
 *  MainU.pas                                                            *
 *  Vladimr Slvik 2007                                                 *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  Main from of UpConvert - helper utility for Shades, which converts   *
 *    old version's settings to new.                                     *
 *                                                                       *
 *  -additional libraries: Shades                                        *
 *************************************************************************)

// first version for 5.0, just copy - format is still backward compatible

unit MainU;

{$I ../../Switches.inc}

//------------------------------------------------------------------------------

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

//------------------------------------------------------------------------------

type
  TMainFrm = class(TForm)
    btnOK: TButton;
    Label1: TLabel;
    lbxSource: TListBox;
    btnCancel: TButton;
    cbDelete: TCheckBox;
    memInfo: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
  private
    FFolders: TStrings;
  public
    { Public declarations }
  end;

var MainFrm: TMainFrm;
    AppDataPath: String;

//==============================================================================
implementation

uses StrU, FileU, TranslationU, TransGuiU,
     SysLowU, ConstStrU,
     ConvertU;

{$R *.dfm}
//------------------------------------------------------------------------------

procedure TMainFrm.FormCreate(Sender: TObject);
begin
  FFolders:= TStringList.Create;
  AppDataPath:= GoodSlashes(GetAppDataPath + '/Shades/');
  FindFolders(AppDataPath + '*', FFolders, True, True, True, True);
  StringsDeleteStartingWith(FFolders, '.');
  lbxSource.Items.Assign(FFolders);
end;

//------------------------------------------------------------------------------

procedure TMainFrm.btnCancelClick(Sender: TObject);
begin
  Close;
end;

//------------------------------------------------------------------------------

procedure TMainFrm.btnOKClick(Sender: TObject);
var OldAsStr: String;
    Index, i: Integer;
    IsValid: Boolean;
    ConvertProc: TConvertProc;
const ThisVersion = '5.0';
begin
  Index:= lbxSource.ItemIndex;
  if Index > -1 then begin
    OldAsStr:= lbxSource.Items[Index];
    IsValid:= True;
    for i:= 1 to Length(OldAsStr) do if not (OldAsStr[i] in ['0'..'9', '.']) then begin
      IsValid:= False;
      Break;
    end;
    // check if folder name is in proper format
    if IsValid then begin
      // do conversion...
      ConvertProc:= FindConversion(OldAsStr, ThisVersion);
      if Assigned(ConvertProc) then begin
        ConvertProc(AppDataPath + OldAsStr, AppDataPath + ThisVersion);
        // convert
        Application.MessageBox(PChar(Translate('Conversion finished.')), //t+
          PChar(Translate('Information')), //t+
          MB_OK + MB_ICONINFORMATION);
        if cbDelete.Checked then begin
          SysLowU.DeleteFileSystemObject(Handle, AppDataPath + OldAsStr, True);
        end;
      end else begin
        // did not find any conversion proc in db...
        Application.MessageBox(PChar(Translate('Sorry, no known conversion from this version.')), //t+
          Pchar(Translate(sscMsgCapError)),
          MB_OK + MB_ICONERROR);
      end;
    end else begin
      // no, it's some alien folder that snuck up on us! run! 
      Application.MessageBox(PChar(Translate('This is not recognized as a data folder of any known version.')), //t+
        Pchar(Translate(sscMsgCapError)),
        MB_OK + MB_ICONERROR);
    end;
  end else begin
    // hey, select an _item_ in that listbox first!
    Application.MessageBox(PChar(Translate('Nothing is selected.')), //t+
      Pchar(Translate(sscMsgCapError)),
      MB_OK + MB_ICONERROR);
  end;
end;

//------------------------------------------------------------------------------

end.
