(*************************************************************************
 *  ToolPaintPencilU.pas                                                 *
 *  Vladimr Slvik 2009-10                                              *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  Pencil tool for painting.                                            *
 *                                                                       *
 *  -additional libraries: Graphics32                                    *
 *************************************************************************)

unit ToolPaintPencilU;

{$INCLUDE ..\Switches.inc}
{t default -}

//------------------------------------------------------------------------------

interface

uses Classes, ClassBaseU, GR32, Controls;

//------------------------------------------------------------------------------

type TPaintPencilTool = class(TMouseToolBase)
       constructor Create(AEngine: TPictureEngineBase); override;
     private
       FLastPoint: TPoint;
     public
       procedure MouseMove(const X, Y: Integer; const Shift: TShiftState);
         override;
       procedure MouseDown(const Button: TMouseButton; const X, Y: Integer;
         const Shift: TShiftState); override;
       procedure MouseUp(const Button: TMouseButton; const X, Y: Integer;
         const Shift: TShiftState); override;
       procedure MouseLeave; override;
       procedure Cancel; override;
     end;

//==============================================================================
implementation

uses CoreLowU, SysUtils, CoreEngineU, CalcUtilU;
//==============================================================================

constructor TPaintPencilTool.Create(AEngine: TPictureEngineBase);
begin
  inherited Create(AEngine);
  FLastPoint:= OuterPoint;
end;

//------------------------------------------------------------------------------

procedure TPaintPencilTool.MouseMove(const X, Y: Integer; const Shift: TShiftState);
var R: TRect;
    Clr: TColor32;
begin
  if FActive and not PointsEqual(Point(X,Y), FLastPoint) then begin
    Clr:= FEngine.ToolOptions.Color or $FF000000;
    Assert(Assigned(FEngine));
    if not PtIs0(FLastPoint) then begin
      FEngine.Overlay.LineS(FLastPoint.X, FLastPoint.Y, X, Y, Clr, True);
      R:= Rect(FLastPoint, Point(X, Y)); // not guaranteed that it is valid yet!
      CorrRect(R); // ...so reshuffle the numbers for validity
      R:= GrowRect(R); // and make it contain one pixel more on needed sides
    end else begin
      FEngine.Overlay.PixelS[X,Y]:= Clr;
      R:= Rect(X, Y, X+1, Y+1); // same as above
    end;
    FLastPoint:= Point(X, Y);
    FChangeArea:= AccumulateRect(FChangeArea, R);
    FEngine.UpdateRect(R);
    FEngine.RedrawRect(R);
  end;
end;

//------------------------------------------------------------------------------

procedure TPaintPencilTool.MouseDown(const Button: TMouseButton;
    const X, Y: Integer; const Shift: TShiftState);
begin
  if (not FActive) and (Button = mbLeft) then begin
    // start activity
    Assert(Assigned(FEngine));
    FActive:= True; // activate
    FLastPoint:= OuterPoint;
    Self.MouseMove(X, Y, Shift); // and paint the first pixel
  end else if FActive and (Button = mbRight) then begin
    // stop activity
    Cancel;
  end;
end;

//------------------------------------------------------------------------------

procedure TPaintPencilTool.MouseUp(const Button: TMouseButton;
    const X, Y: Integer; const Shift: TShiftState);
begin
  if FActive and (Button = mbLeft) then begin
    // apply saved changes
    FActive:= False;
    FLastPoint:= OuterPoint;
    FEngine.CommitOverlay(FChangeArea);
    FEngine.RedrawRect(FChangeArea);
    FChangeArea:= ZeroRect;
  end;
end;

//------------------------------------------------------------------------------

procedure TPaintPencilTool.MouseLeave; {$I EMPTY.inc}
// do not react, keep painting

//------------------------------------------------------------------------------

procedure TPaintPencilTool.Cancel;
begin
  if FActive then begin // and this ends activity
    FActive:= False;
    FLastPoint:= OuterPoint;
    FEngine.DiscardOverlay;
    FEngine.UpdateRect(FChangeArea);
    FEngine.RedrawRect(FChangeArea);
    FChangeArea:= ZeroRect;
  end;
end;

//------------------------------------------------------------------------------

end.
