(*************************************************************************
 *  ToolOptionsU.pas                                                     *
 *  Vladimr Slvik 2009-10                                              *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  Common config for all tools, with unlucky dependence on main form.   *
 *                                                                       *
 *  -additional libraries: Graphics32                                    *
 *************************************************************************)

unit ToolOptionsU;

{$INCLUDE ..\Switches.inc}
{t default -}

//------------------------------------------------------------------------------

interface

uses GR32, Forms;

//------------------------------------------------------------------------------

type TToolOptions = class
     private
       FBrush: TBitmap32;
       procedure SetBrush(const NewBrush: TBitmap32);
     public
       DiagonalFill: Boolean;
       RemoveGlowing: Boolean;
       RemovePlayer: Boolean;
       Color: TColor32;
       constructor Create;
       destructor Destroy; override;
       procedure LoadFromForm(const AForm: TForm);
       property Brush: TBitmap32 read FBrush write SetBrush;
     end;

//------------------------------------------------------------------------------

implementation

uses SysUtils, Windows, MainU, CbFrameU, TranslationU, ConstStrU;

//------------------------------------------------------------------------------

constructor TToolOptions.Create;
begin
  FBrush:= TBitmap32.Create;
end;

//------------------------------------------------------------------------------

destructor TToolOptions.Destroy;
begin
  FBrush.Free;
end;

//------------------------------------------------------------------------------

procedure TToolOptions.SetBrush(const NewBrush: TBitmap32);
begin
  FBrush.Assign(NewBrush);
end;

//------------------------------------------------------------------------------

procedure TToolOptions.LoadFromForm(const AForm: TForm);
var DataForm: TMainFrm;
begin
  try
    DataForm:= AForm as TMainFrm;
    DiagonalFill:= DataForm.CbFrame.cbFillDiag.Checked;
    RemoveGlowing:= DataForm.CbFrame.cbNight.Checked;
    RemovePlayer:= DataForm.CbFrame.cbPlayer.Checked;
    Color:= DataForm.SelectedColor;
  except on E: Exception do 
    Application.MessageBox(PChar(_(Format(
      'Bad typecast in TToolOptions.LoadFromForm, attempting to open %s!', //tf
      [AForm.Name]))), PChar(_(sscMsgCapError)), MB_OK + MB_ICONERROR);
  end;
end;                               

//------------------------------------------------------------------------------

end.
