(*************************************************************************
 *  AboutU.pas + AboutU.dfm                                              *
 *  Vladimr Slvik 2005-10                                              *
 *  Delphi 7 Personal                                                    *
 *  cp1250                                                               *
 *                                                                       *
 *  about form of Shades :                                               *
 *    some pictures and text                                             *
 *                                                                       *
 *  -additional libraries: PNGImage                                      *
 *************************************************************************)

unit AboutU;

{$INCLUDE Switches.inc}
{t default -}

interface

uses
  SysUtils, Forms, Controls, StdCtrls, ExtCtrls, ComCtrls, Grids, ValEdit,
  Classes,
  UrlLabel;

type
  TAboutFrm = class(TForm)
    imLogo: TImage;
    pnlImage: TPanel;
    imgAbout: TImage;
    lbVersion: TLabel;
    lbAuthor: TLabel;
    btnClose: TButton;
    pnlHeading: TPanel;
    memAbout: TMemo;
    pcAbout: TPageControl;
    tsInfo: TTabSheet;
    tsVersions: TTabSheet;
    vleBuild: TValueListEditor;
    tsThanks: TTabSheet;
    imThanks: TImage;
    stWebSimu: TStaticText;
    stWebGr32: TStaticText;
    procedure FormCreate(Sender: TObject);
    procedure StaticTextClick(Sender: TObject);
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  private
    FThanksList: TStrings;
    FAboutList: TStrings;
    FRefresh: TNotifyEvent;
    procedure RenderThanks(const Text: TStrings; const Target: TImage);
    procedure InfoTable;
    procedure TrRefresh(Sender: TObject);
  published
    property OnTranslationRefresh: TNotifyEvent read FRefresh;
  end;

var
  AboutFrm: TAboutFrm;

//==============================================================================

implementation

uses PngImage, GR32, GR32_System,
     ShellAPI, StrUtils, Windows, Graphics, Dialogs,
     MainU, SysLowU, ConstStrU,
     TranslationU, TransGuiU;

{$R *.dfm}

//------------------------------------------------------------------------------

procedure TAboutFrm.FormCreate(Sender: TObject);
var P: TPngObject;
begin
  lbVersion.Caption:= sscAboutDlgVersion;
  imLogo.Picture.Icon.Assign(Application.Icon);
  try
    P:= TPNGObject.Create;
    P.LoadFromResourceName(hInstance,'AboutPicture');
    imgAbout.Picture.Assign(P);
  finally
    P.Free;
  end;
  // picture from png resource
  imThanks.Picture.Bitmap.Canvas.Font.Assign(memAbout.Font);
  RenderThanks(FThanksList, imThanks);
  // render thanks
  TranslateComponent(Self);
  Font.Name:= Translate(sscFontName);
  InfoTable;
  pcAbout.ActivePageIndex:= 0;
end;

//------------------------------------------------------------------------------

procedure TAboutFrm.StaticTextClick(Sender: TObject);
begin
  WinOpen(Handle, (Sender as TStaticText).Caption);
end;

//------------------------------------------------------------------------------

procedure TAboutFrm.RenderThanks(const Text: TStrings; const Target: TImage);
var i: Integer;
    F: TFont;
    S: String;
    Y: Integer;
    C: TCanvas;
    R: TRect;
const cLineBreak = 4;
      cParagraphBreak = 8;
begin
    with Target.Picture.Bitmap do begin
      Width:= Target.Width;
      Height:= Target.Height;
      //TransparentColor:= clWhite;
      //Transparent:= True;
    end;
    C:= imThanks.Picture.Bitmap.Canvas;
    F:= C.Font;
    C.Brush.Color:= clBtnFace;
    R:= Target.BoundsRect;
    C.FillRect(R);
    Y:= 0;
    for i:= 0 to Text.Count - 1 do begin
      S:= Text.Strings[i];
      if Length(S) > 0 then case S[1] of
        '*': begin
          F.Style:= [fsBold];
          Inc(Y, cParagraphBreak);
          S:= Utf8ToAnsi(RightStr(S, Length(S) - 1)); // rid of *
          C.TextOut(0, Y, S);
          Inc(Y, Abs(F.Height));
        end;
        '!': begin
          Inc(Y, cParagraphBreak);
          S:= RightStr(S, Length(S) - 1); // rid of !
          C.TextOut(0, Y, S);
          Inc(Y, Abs(F.Height));
        end;
        else begin
          F.Style:= [];
          Inc(Y, cLineBreak);
          S:= Translate(S); // translate
          C.TextOut(20, Y, S);
          Inc(Y, Abs(F.Height));
        end;
      end else begin
        Inc(Y, cLineBreak);
        Inc(Y, Abs(F.Height));
      end;
    end;
end;

//------------------------------------------------------------------------------

{t default +}
procedure TAboutFrm.InfoTable;
begin
  with vleBuild.Strings do begin
    Clear;
    Values[_('Graphics32 version')]:= GR32.Graphics32Version;
    Values[_('PNGImage version')]:= PNGImage.LibraryVersion;
    Values[_('SVN revision')]:=
      {$IFNDEF NO_SVN} {$INCLUDE svnversion.txt} {$ELSE} _('Unknown') {$ENDIF};
    Values[_('Build date')]:=
      {$IFNDEF NO_SVN} {$INCLUDE builddate.txt} {$ELSE} _('Unknown') {$ENDIF};
    Values[_('x86 - optimized core')]:= Translate(
      {$IFNDEF NO_ASSEMBLY} 'Yes' {$ELSE} 'No' {$ENDIF} );
    (*Values[_('Compiler version')]:= #32; // HOWTO? //t- *)
    Values[_('Debug build')]:= Translate(
      {$IFDEF DEBUG} 'Yes' {$ELSE} 'No' {$ENDIF} );
    Values[_('Assertions')]:= Translate(
      {$IFOPT C+} 'Yes' {$ELSE} 'No' {$ENDIF} );
    Values[_('Range checking')]:= Translate(
      {$IFOPT R+} 'Yes' {$ELSE} 'No' {$ENDIF});
    Values[_('Overflow checking')]:= Translate(
      {$IFOPT Q+} 'Yes' {$ELSE} 'No' {$ENDIF});
    Values[_('Compiler')]:= 'Delphi'; //t+-
    {$IF Defined(CPU386) or Defined(i386)}
    Values[_('CPU features MMX')]:=
      _(IfThen(HasMMX, 'Yes', 'No'));
    {$IFEND}
    Values[_('OS version number')]:=
      StringReplace(FloatToStr(OSNumber/100), ',', '.', []); //t-
    // version notation - number like 5.01 or such
    // easier to postprocess as string than bothering with locales
  end;
end;
{t default -}

//------------------------------------------------------------------------------

procedure TAboutFrm.TrRefresh(Sender: TObject);
begin
  if Assigned(FThanksList) then begin
    TranslateStrings(FThanksList);
    TranslateStrings(FAboutList);
    RenderThanks(FThanksList, imThanks);
    memAbout.Lines.Assign(FAboutList);
    InfoTable;
  end;
end;

//==============================================================================

constructor TAboutFrm.Create(AOwner: TComponent);
var RS: TStream;
begin
  inherited Create(AOwner);
  FRefresh:= TrRefresh;
  FThanksList:= TStringList.Create;
  FAboutList:= TStringList.Create;
  try
    RS:= TResourceStream.Create(HInstance, 'THANKS', RT_RCDATA);
    FThanksList.LoadFromStream(RS);
  finally
    RS.Free;
  end;
  try
    RS:= TResourceStream.Create(HInstance, 'ABOUT', RT_RCDATA);
    FAboutList.LoadFromStream(RS);
  finally
    RS.Free;
  end;
end;

//------------------------------------------------------------------------------

destructor TAboutFrm.Destroy;
begin
  FThanksList.Free;
  inherited Destroy;
end;

//------------------------------------------------------------------------------

end.
