unit MainU;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ExtDlgs, ClipBrd, PngImage, Jpeg, Buttons;

type
  TMainFrm = class(TForm)
    btnShow: TButton;
    btnSave: TButton;
    Shape1: TShape;
    Shape2: TShape;
    Shape3: TShape;
    rbtnRight: TRadioButton;
    rbtnDown: TRadioButton;
    Label1: TLabel;
    btnAdd: TButton;
    btnAddClip: TButton;
    OpenPictureDialog: TOpenPictureDialog;
    SavePictureDialog: TSavePictureDialog;
    btnDel: TButton;
    btnExit: TButton;
    SpeedButton1: TSpeedButton;
    procedure rbtnRightClick(Sender: TObject);
    procedure rbtnDownClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnAddClipClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure btnShowClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure btnDelClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    procedure Process;
  public
    { Public declarations }
  end;

var
  MainFrm: TMainFrm;
  AddImg: TPicture; 
  Img: TBitmap;

implementation

uses ShowU, AboutU;

{$R *.dfm}

procedure TMainFrm.Process;
var oldWidth, oldHeight: Integer;
begin
  if rbtnRight.Checked then
   begin
    oldWidth:= Img.Width;
    Img.Width:= Img.Width + AddImg.Width;
    if AddImg.Height > Img.Height then Img.Height:=AddImg.Height;
    Img.Canvas.Draw(oldWidth,0,AddImg.Graphic);
   end
  else // rbtnDown.Checked
   begin
    oldHeight:= Img.Height;
    Img.Height:= Img.Height + AddImg.Height;
    if AddImg.Width > Img.Width then Img.Width:= AddImg.Width;
    Img.Canvas.Draw(0,oldHeight,AddImg.Graphic); 
   end;
end;

procedure TMainFrm.rbtnRightClick(Sender: TObject);
begin
 Shape2.Brush.Color:=clHighlight;
 Shape3.Brush.Color:=clWhite;
end;

procedure TMainFrm.rbtnDownClick(Sender: TObject);
begin
 Shape3.Brush.Color:=clHighlight;
 Shape2.Brush.Color:=clWhite;
end;

procedure TMainFrm.FormCreate(Sender: TObject);
begin
 Img:=TBitmap.Create;
 AddImg:= TPicture.Create;
end;

procedure TMainFrm.FormDestroy(Sender: TObject);
begin
 Img.Free;
 AddImg.Free;
end;

procedure TMainFrm.btnAddClipClick(Sender: TObject);
begin
 if Clipboard.HasFormat(CF_BITMAP) then
  begin
   AddImg.Assign(Clipboard);
   Process;
  end; 
end;

procedure TMainFrm.btnAddClick(Sender: TObject);
begin
 if OpenPictureDialog.Execute then
  try
   try
    AddImg.LoadFromFile(OpenPictureDialog.FileName);
    Process;
   except
    on E:Exception do ShowMessage(E.Message);
   end; 
  finally
   // ?
  end;
end;

procedure TMainFrm.btnShowClick(Sender: TObject);
begin
 ShowFrm.ImgView321.Bitmap.Assign(Img);
 ShowFrm.ShowModal;
end;

procedure TMainFrm.btnSaveClick(Sender: TObject);
begin
 if SavePictureDialog.Execute then
  Img.SaveToFile(SavePictureDialog.FileName); 
end;

procedure TMainFrm.btnDelClick(Sender: TObject);
begin
 Img.Width:=0;
 Img.Height:=0;
end;

procedure TMainFrm.btnExitClick(Sender: TObject);
begin
 Close;
end;

procedure TMainFrm.SpeedButton1Click(Sender: TObject);
begin
 AboutFrm.ShowModal;
end;

end.
